% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_rowwise.R
\name{mutate_rowwise.}
\alias{mutate_rowwise.}
\title{Add/modify columns by row}
\usage{
mutate_rowwise.(.df, ...)
}
\arguments{
\item{.df}{A data.table or data.frame}

\item{...}{Columns to add/modify}
}
\description{
Allows you to mutate "by row". this is most useful when a vectorized function doesn't exist.
}
\examples{
df <- data.table(x = runif(6), y = runif(6), z = runif(6))

# Compute the mean of x, y, z in each row
df \%>\%
  mutate_rowwise.(row_mean = mean(c(x, y, z)))

# Use c_across.() to more easily select many variables
df \%>\%
  mutate_rowwise.(row_mean = mean(c_across.(x:z)))
}
