% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in-notin.R
\name{\%in\%}
\alias{\%in\%}
\alias{\%notin\%}
\title{Fast \code{\%in\%} and \verb{\%notin\%} operators}
\usage{
x \%in\% y

x \%notin\% y
}
\arguments{
\item{x}{A vector of values to check if they exist in y}

\item{y}{A vector of values to check if x values exist in}
}
\description{
Check whether values in a vector are in or not in another vector.

Built using \code{data.table::'\%chin\%'} and \code{vctrs::vec_in()} for performance.
}
\details{
Falls back to \code{base::'\%in\%'} when x and y don't share a common type.
This means that the behaviour of \code{base::'\%in\%'} is preserved (e.g. \code{"1" \%in\% c(1, 2)} is \code{TRUE})
but loses the speedup provided by \code{vctrs::vec_in()}.
}
\examples{
df <- tidytable(x = 1:4, y = 1:4)

df \%>\%
  filter(x \%in\% c(2, 4))

df \%>\%
  filter(x \%notin\% c(2, 4))
}
