% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize}
\alias{summarize}
\alias{summarise}
\title{Aggregate data using summary statistics}
\usage{
summarize(
  .df,
  ...,
  .by = NULL,
  .sort = TRUE,
  .groups = "drop_last",
  .unpack = FALSE
)

summarise(
  .df,
  ...,
  .by = NULL,
  .sort = TRUE,
  .groups = "drop_last",
  .unpack = FALSE
)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Aggregations to perform}

\item{.by}{Columns to group by.
\itemize{
\item A single column can be passed with \code{.by = d}.
\item Multiple columns can be passed with \code{.by = c(c, d)}
\item \code{tidyselect} can be used:
\itemize{
\item Single predicate: \code{.by = where(is.character)}
\item Multiple predicates: \code{.by = c(where(is.character), where(is.factor))}
\item A combination of predicates and column names: \code{.by = c(where(is.character), b)}
}
}}

\item{.sort}{\emph{experimental}: Default \code{TRUE}.
If FALSE the original order of the grouping variables will be preserved.}

\item{.groups}{Grouping structure of the result
\itemize{
\item "drop_last": Drop the last level of grouping
\item "drop": Drop all groups
\item "keep": Keep all groups
}}

\item{.unpack}{\emph{experimental}: Default \code{FALSE}. Should unnamed data frame inputs be unpacked.
The user must opt in to this option as it can lead to a reduction in performance.}
}
\description{
Aggregate data using summary statistics such as mean or median. Can be calculated by group.
}
\examples{
df <- data.table(
  a = 1:3,
  b = 4:6,
  c = c("a", "a", "b"),
  d = c("a", "a", "b")
)

df \%>\%
  summarize(avg_a = mean(a),
            max_b = max(b),
            .by = c)

df \%>\%
  summarize(avg_a = mean(a),
            .by = c(c, d))
}
