% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_coltab.R, R/scales_wiki.R
\name{scale_color_coltab}
\alias{scale_color_coltab}
\alias{scale_wiki}
\alias{scale_fill_wiki_d}
\alias{scale_colour_wiki_d}
\alias{scale_color_wiki_d}
\alias{scale_fill_wiki_c}
\alias{scale_colour_wiki_c}
\alias{scale_color_wiki_c}
\alias{scale_fill_wiki_b}
\alias{scale_colour_wiki_b}
\alias{scale_color_wiki_b}
\alias{wiki.colors}
\title{Gradient scales from Wikipedia color schemes}
\usage{
scale_fill_wiki_d(
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_colour_wiki_d(
  ...,
  alpha = 1,
  direction = 1,
  na.translate = FALSE,
  drop = TRUE
)

scale_fill_wiki_c(
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "colourbar"
)

scale_colour_wiki_c(
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "colourbar"
)

scale_fill_wiki_b(
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "coloursteps"
)

scale_colour_wiki_b(
  ...,
  alpha = 1,
  direction = 1,
  na.value = "transparent",
  guide = "coloursteps"
)

wiki.colors(n, alpha = 1, rev = FALSE)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}, \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale}}, \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation.
}}
    \item{\code{n.breaks}}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}
    \item{\code{nice.breaks}}{Logical. Should breaks be attempted placed at nice values
instead of exactly evenly spaced between the limits. If \code{TRUE} (default)
the scale will ask the transformation object to create breaks, and this
may result in a different number of breaks than requested. Ignored if
breaks are given explicitly.}
  }}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{na.translate}{Should \code{NA} values be removed from the legend? Default
is \code{TRUE}.}

\item{na.value}{Missing values will be replaced with this value. By default,
\CRANpkg{tidyterra} uses \code{na.value = "transparent"} so cells with \code{NA} are
not filled. See also
\href{https://github.com/dieghernan/tidyterra/issues/120}{#120}.}

\item{drop}{Should unused factor levels be omitted from the scale? The
default (\code{TRUE}) removes unused factors.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{n}{the number of colors (\eqn{\ge 1}) to be in the
    palette.}

\item{rev}{logical indicating whether the ordering of the colors should
    be reversed.}
}
\value{
The corresponding ggplot2 layer with the values applied to the
\code{fill/colour} aesthetics.
}
\description{
Implementation based on the
\href{https://en.wikipedia.org/wiki/Wikipedia:WikiProject_Maps/Conventions/Topographic_maps}{Wikipedia Colorimetric conventions for topographic maps}.
Three scales are provided:
\itemize{
\item \verb{scale_*_wiki_d()}: For discrete values.
\item \verb{scale_*_wiki_c()}: For continuous values.
\item \verb{scale_*_wiki_b()}: For binning continuous values.
}

Additionally, a color palette \code{wiki.colors()} is provided. See also
\code{\link[grDevices:palettes]{grDevices::terrain.colors()}} for details.

Additional parameters \code{...} would be passed on to:
\itemize{
\item Discrete values: \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}
\item Continuous values: \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}
\item Binned continuous values: \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}}.
}

Note that \pkg{tidyterra} just documents a selection of these additional
parameters, check the previous links to see the full range of parameters
accepted by these scales.
}
\examples{
\donttest{
filepath <- system.file("extdata/volcano2.tif", package = "tidyterra")

library(terra)
volcano2_rast <- rast(filepath)

# Palette
plot(volcano2_rast, col = wiki.colors(100))

library(ggplot2)
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_wiki_c()

# Binned
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_wiki_b(breaks = seq(70, 200, 10))

# With discrete values
factor <- volcano2_rast \%>\% mutate(cats = cut(elevation,
  breaks = c(100, 120, 130, 150, 170, 200),
  labels = c(
    "Very Low", "Low", "Average", "High",
    "Very High"
  )
))


ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_wiki_d(na.value = "gray10")
}
}
\seealso{
\code{\link[terra:plot]{terra::plot()}}, \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}

See also \pkg{ggplot2} docs on additional \code{...} parameters:
\itemize{
\item \verb{scale_*_terrain_d()}: For discrete values.
\item \verb{scale_*_terrain_c()}: For continuous values.
\item \verb{scale_*_terrain_b()}: For binning continuous values.
}

Other gradient scales and palettes for hypsometry:
\code{\link{scale_cross_blended}},
\code{\link{scale_hypso}},
\code{\link{scale_terrain}},
\code{\link{scale_whitebox}}
}
\concept{gradients}
