% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct-SpatVector.R
\name{distinct.SpatVector}
\alias{distinct.SpatVector}
\title{Keep distinct/unique rows and geometries of \code{SpatVector} objects}
\usage{
\method{distinct}{SpatVector}(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{A \code{SpatVector} created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Optional variables to
use when determining uniqueness. If there are multiple rows for a given
combination of inputs, only the first row will be preserved. If omitted,
will use all variables in the data frame. There is a reserved variable
name, \code{geometry}, that would remove duplicate geometries. See \strong{Methods}.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}
}
\value{
A \code{SpatVector} object.
}
\description{
Keep only unique/distinct rows and geometries from a \code{SpatVector}.
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:unique]{terra::unique()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:distinct]{dplyr::distinct()}} function.
\subsection{\code{SpatVector}}{

It is possible to remove duplicate geometries including the geometry
variable explicitly in the \code{...} call. See \strong{Examples}.
}
}

\examples{

library(terra)

v <- vect(system.file("ex/lux.shp", package = "terra"))

# Create a vector with dups
v <- v[sample(seq_len(nrow(v)), 100, replace = TRUE), ]
v$gr <- sample(LETTERS[1:3], 100, replace = TRUE)

# All duplicates
ex1 <- distinct(v)
ex1

nrow(ex1)

# Duplicates by NAME_1
ex2 <- distinct(v, gr)
ex2
nrow(ex2)

# Same but keeping all cols
ex2b <- distinct(v, gr, .keep_all = TRUE)
ex2b
nrow(ex2b)


# Unique geometries
ex3 <- distinct(v, geometry)

ex3
nrow(ex3)
# Same as terra::unique()
terra::unique(ex3)

# Unique keeping info
distinct(v, geometry, .keep_all = TRUE)
}
\seealso{
\code{\link[dplyr:distinct]{dplyr::distinct()}}, \code{\link[terra:unique]{terra::unique()}}

Other \CRANpkg{dplyr} verbs that operate on rows:
\code{\link{arrange.SpatVector}()},
\code{\link{filter.Spat}},
\code{\link{slice.Spat}}

Other \CRANpkg{dplyr} methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.methods}
\concept{dplyr.rows}
