% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{interlude}
\alias{interlude}
\title{An interlude in a magrittr pipeline}
\usage{
interlude(.df, .language)
}
\arguments{
\item{.df}{Data argument, typical "first" argument in dplyr verbs}

\item{.language}{Language}
}
\value{
Unchanged .df
}
\description{
The given language is executed, with the pronoun "." set to .df
(usually the data frame sent through the pipeline),
but the results are ignored, and the next line in the pipeline gets the unchanged data.
Any executed code is allowed to edit variables which already exist in the
calling environment. This is useful to store intermediate results.
}
\details{
Note: Detection of the calling environment is not solved cleanly;
it cannot be excluded that it fails under specific circumstances.
}
\examples{
library(tibble)
library(magrittr)
library(dplyr)
x <- c() # now x exists in the calling env
tibble(a=1, b=2) \%>\%
   mutate(b=a+3) \%>\%
   interlude(x <- .$b) \%>\%
   mutate(a=a+1)
# x is set to 4
}
