% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_water.R
\name{define_water}
\alias{define_water}
\title{Create a water class object given water quality parameters}
\usage{
define_water(
  ph,
  temp = 25,
  alk,
  tot_hard,
  ca,
  mg,
  na,
  k,
  cl,
  so4,
  tot_ocl = 0,
  tot_po4 = 0,
  tot_nh3 = 0,
  tds,
  cond,
  toc,
  doc,
  uv254,
  br,
  f,
  fe,
  al,
  mn
)
}
\arguments{
\item{ph}{water pH}

\item{temp}{Temperature in degree C}

\item{alk}{Alkalinity in mg/L as CaCO3}

\item{tot_hard}{Total hardness in mg/L as CaCO3}

\item{ca}{Calcium in mg/L Ca2+}

\item{mg}{Magnesium in mg/L Mg2+}

\item{na}{Sodium in mg/L Na+}

\item{k}{Potassium in mg/L K+}

\item{cl}{Chloride in mg/L Cl-}

\item{so4}{Sulfate in mg/L SO42-}

\item{tot_ocl}{Chlorine in mg/L as Cl2. Used when a starting water has a chlorine residual.}

\item{tot_po4}{Phosphate in mg/L as PO4 3-. Used when a starting water has a phosphate residual.}

\item{tot_nh3}{Total ammonia in mg/L as N}

\item{tds}{Total Dissolved Solids in mg/L (optional if ions are known)}

\item{cond}{Electrical conductivity in uS/cm (optional if ions are known)}

\item{toc}{Total organic carbon (TOC) in mg/L}

\item{doc}{Dissolved organic carbon (DOC) in mg/L}

\item{uv254}{UV absorbance at 254 nm (cm-1)}

\item{br}{Bromide in ug/L Br-}

\item{f}{Fluoride in mg/L F-}

\item{fe}{Iron in mg/L Fe3+}

\item{al}{Aluminum in mg/L Al3+}

\item{mn}{Manganese in ug/L Mn2+}
}
\value{
A water class object where slots are filled or calculated based on input parameters.
}
\description{
This function takes user-defined water quality parameters and creates an S4 "water" class object that forms the input and output of all tidywater models.
}
\details{
Carbonate balance is calculated and units are converted to mol/L. Ionic strength is determined from ions, TDS, or conductivity. Missing values are handled by defaulting to 0 or
NA. Calcium hardness defaults to 65% of the total hardness because that falls within a typical range. For best results
manually specify all ions in the define_water arguments. The following equations are used to determine ionic strength:
Ionic strength (if TDS provided): Crittenden et al. (2012) equation 5-38
Ionic strength (if electrical conductivity provided): Snoeyink & Jenkins (1980)
Ionic strength (from ion concentrations): Lewis and Randall (1921), Crittenden et al. (2012) equation 5-37
Temperature correction of dielectric constant (relative permittivity): Harned and Owen (1958), Crittenden et al. (2012) equation 5-45.
}
\examples{
water_missingions <- define_water(ph = 7, temp = 15, alk = 100, tds = 10)
water_defined <- define_water(7, 20, 50, 100, 80, 10, 10, 10, 10, tot_po4 = 1)

}
