% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidywater-package.R
\docType{data}
\name{discons}
\alias{discons}
\title{Dissociation constants and standard enthalpy for weak acids/bases}
\format{
A dataframe with 8 rows and 3 columns
\describe{
\item{ID}{Coefficient type}
\item{k}{Equilibrium constant}
\item{deltah}{Standard enthalpy in J/mol}
}
}
\source{
Benjamin (2015) Appendix A.1 and A.2.

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
discons
}
\description{
Equilibrium constants (k) and corresponding standard enthalpy of reaction values (deltah) for significant acids in
water influencing pH at equilibrium. Includes carbonate, sulfate, phosphate, and hypochlorite.
Standard enthalpy of reaction is calculated by taking the sum of the enthalpy of formation of each individual component
minus the enthalpy of formation of the final product. e.g., the standard enthalpy of reaction for water can be
calculated as: deltah_h2o = deltah_f_oh + deltah_f_h - deltah_f_h2o = -230 + 0 - (-285.83) = 55.83 kJ/mol.
See MWH (2012) example 5-5 and Benjamin (2002) eq. 2.96.
}
\keyword{datasets}
