% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_cached_item.R
\name{tw_check_cached_items}
\alias{tw_check_cached_items}
\title{Check if given items are present in cache}
\usage{
tw_check_cached_items(id, language = "all_available")
}
\arguments{
\item{id}{A characther vector. Each element must start with Q, and correspond to a Wikidata identifier.}

\item{language}{Defaults to "all_available". Use to limit the data to be cached. For available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}
}
\value{
A character vector with IDs of items present in cache. If no item found in cache, returns NULL.
}
\description{
Check if given items are present in cache
}
\examples{

tw_set_cache_folder(path = tempdir())
tw_enable_cache()
tw_create_cache_folder(ask = FALSE)

# add three items to local cache
invisible(tw_get(id = "Q180099", language = "en"))
invisible(tw_get(id = "Q228822", language = "en"))
invisible(tw_get(id = "Q184992", language = "en"))

# check if these other items are in cache
items_in_cache <- tw_check_cached_items(
  id = c(
    "Q180099",
    "Q228822",
    "Q76857"
  ),
  language = "en"
)
# it should return only the two items from the current list of id
# but not other item already in cache
items_in_cache
}
