% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get.R
\name{tw_get_description}
\alias{tw_get_description}
\title{Get Wikidata description in given language}
\usage{
tw_get_description(
  id,
  language = "en",
  cache = NULL,
  overwrite_cache = FALSE,
  wait = 0
)
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q254" for Wolfgang Amadeus Mozart}

\item{language}{A character vector of length one, defaults to "en". For a full list of available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A charachter vector of length 1, with the Wikidata description in the requested languae.
}
\description{
Get Wikidata description in given language
}
\examples{
tw_get_description(
  id = c(
    "Q180099",
    "Q228822"
  ),
  language = "en"
)
}
