% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_names.R
\name{xlsx_names}
\alias{xlsx_names}
\title{Import named formulas from xlsx (Excel) files}
\usage{
xlsx_names(path, check_filetype = TRUE)
}
\arguments{
\item{path}{Path to the xlsx file.}

\item{check_filetype}{Logical. Whether to check that the filetype is xlsx (or
xlsm) by looking at the file itself, rather than using the filename
extension.}
}
\value{
A data frame, one row per name, with the following columns.
\itemize{
\item \code{sheet} If the name is defined only for a specific sheet, the name of
the sheet.  Otherwise \code{NA} for names defined globally.
\item \code{name}
\item \code{formula} Usually a range of cells, but sometimes a whole formula, e.g.
\code{MAX(A2,1)}.
\item \code{comment} A description given by the spreadsheet author.
\item \code{hidden} Whether or not the name is visible to the user in spreadsheet
applications.  Hidden names are usually ones that were created
automatically by the spreadsheet application.
\item \code{is_range} Whether or not the \code{formula} is a range of cells.  This is handy
for joining to the set of cells referred to by a name.  In this context,
commas between cell addresses are always regarded as union operators --
this differs from \code{\link[tidyxl:xlex]{tidyxl::xlex()}}, see that help file for details.
}
}
\description{
\code{xlsx_names()} returns the names and definitions of named formulas (aka named
ranges) in xlsx (Excel) files.

Most names refer to ranges of cells, but they can also be defined as
formulas.  \code{xlsx_names()} tells you whether or not they are a range, using
\code{\link[tidyxl:is_range]{tidyxl::is_range()}} to work this out.

Names are scoped either globally (used only once in the file), or locally to
each sheet (can be reused with different definitions in different sheets).
For sheet-scoped names, \code{xlsx_names()} provides the name of the sheet.
}
\examples{
examples <- system.file("extdata/examples.xlsx", package = "tidyxl")
xlsx_names(examples)
}
