% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SampDist2Props}
\alias{SampDist2Props}
\title{Difference of Two Sample Proportions}
\usage{
SampDist2Props(form,data,max.sample.sizes=100,sim.reps=1000)
}
\arguments{
\item{form}{An object of class formula, of the form ~x+y where x and y are factors supplied by:}

\item{data}{A dataframe, representing the imaginary population.  In the formula, both factors should have exactly two levels.
The variable x represents the explanatory variable.}

\item{max.sample.sizes}{Maximum sample sizes allowed on the sliders.}

\item{sim.reps}{Number of samples to construct the empirical distribution.}
}
\value{
Graphical and numerical output.
}
\description{
An app to explore the sampling distribution of the difference of two sample proportions.
}
\examples{
\dontrun{
data(imagpop)
SampDist2Props(~sex+cappun,data=imagpop)
}
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}

