% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotNovel}
\alias{plotNovel}
\title{Visualize evidence of novel V alleles}
\usage{
plotNovel(clip_db, novel_df_row, ncol = 1)
}
\arguments{
\item{clip_db}{a \code{data.frame} in Change-O format. See
\link{findNovelAlleles} for details.}

\item{novel_df_row}{a single row from a data frame as output by
\link{findNovelAlleles} that contains a
polymorphism-containing germline allele}

\item{ncol}{number of columns to use when laying out the plots}
}
\description{
\code{plotNovel} is be used to visualize the evidence of any novel V
alleles found using \link{findNovelAlleles}.
}
\examples{
# Load example data and germlines
data(sample_db)
data(germline_ighv)

# Find novel alleles and return relevant data
\dontrun{novel_df = findNovelAlleles(sample_db, germline_ighv)}
data(novel_df)
# Plot the evidence for the first (and only) novel allele in the example data
novel = selectNovel(novel_df)
plotNovel(sample_db, novel[1,])

}

