% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro_areas.R
\name{core_based_statistical_areas}
\alias{core_based_statistical_areas}
\title{Download a core-based statistical area shapefile into R}
\usage{
core_based_statistical_areas(cb = FALSE, resolution = "500k", year = NULL,
  ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Core-based statistical areas include both metropolitan areas and micropolitan areas.  The US Census
Bureau defines these areas as follows: "A metro area contains a core urban area of 50,000 or more population, and a
micro area contains an urban core of at least 10,000 (but less than 50,000) population. Each metro or micro area
consists of one or more counties and includes the counties containing the core urban area, as well as any adjacent
counties that have a high degree of social and economic integration (as measured by commuting to work) with the urban
core."  Please see the link provided for more information
}
\seealso{
\url{http://www.census.gov/population/metro/}

Other metro area functions: \code{\link{combined_statistical_areas}},
  \code{\link{metro_divisions}}, \code{\link{new_england}},
  \code{\link{urban_areas}}
}

