% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landmarks.R
\name{military}
\alias{military}
\title{Download the Military Installation National Shapefile into R}
\usage{
military(year = NULL, ...)
}
\arguments{
\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Description from the US Census Bureau: "The Census Bureau includes landmarks
such as military installations in the MAF/TIGER database for
locating special features and to help enumerators during field operations. The Census Bureau adds
landmark features to the database on an as-needed basis and does not attempt to ensure that all
instances of a particular feature are included. For additional information about area landmarks, please
see Section 3.12, Landmarks (Area and Point)."
}
\details{
This file does not include the three point landmarks identified as military installation features in the
MAF/TIGER database. These point landmarks are included in the point landmark shapefile.
Although almost all military installations have assigned 8-character National Standard (GNIS) codes, the
Census Bureau has not loaded most of this data into the MAF/TIGER database. The 2015 military
shapefiles contain few values in the ANSICODE field.
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc_Ch3.pdf}
}

