% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TileDBArray.R
\name{tiledb_array}
\alias{tiledb_array}
\title{Constructs a tiledb_array object backed by a persisted tiledb array uri}
\usage{
tiledb_array(
  uri,
  query_type = c("READ", "WRITE"),
  is.sparse = NA,
  as.data.frame = FALSE,
  attrs = character(),
  extended = TRUE,
  selected_ranges = list(),
  query_layout = character(),
  datetimes_as_int64 = FALSE,
  encryption_key = character(),
  timestamp = as.POSIXct(double(), origin = "1970-01-01"),
  as.matrix = FALSE,
  as.array = FALSE,
  query_condition = new("tiledb_query_condition"),
  timestamp_start = as.POSIXct(double(), origin = "1970-01-01"),
  timestamp_end = as.POSIXct(double(), origin = "1970-01-01"),
  return_as = get_return_as_preference(),
  ctx = tiledb_get_context()
)
}
\arguments{
\item{uri}{uri path to the tiledb dense array}

\item{query_type}{optionally loads the array in "READ" or "WRITE" only modes.}

\item{is.sparse}{optional logical switch, defaults to "NA" letting array determine it}

\item{as.data.frame}{optional logical switch, defaults to "FALSE"}

\item{attrs}{optional character vector to select attributes, default is
empty implying all are selected}

\item{extended}{optional logical switch selecting wide \sQuote{data.frame}
format, defaults to "TRUE"}

\item{selected_ranges}{optional A list with matrices where each matrix i
describes the (min,max) pair of ranges for dimension i}

\item{query_layout}{optional A value for the TileDB query layout, defaults to
an empty character variable indicating no special layout is set}

\item{datetimes_as_int64}{optional A logical value selecting date and datetime value
representation as \sQuote{raw} \code{integer64} and not as \code{Date},
\code{POSIXct} or \code{nanotime} objects.}

\item{encryption_key}{optional A character value with an AES-256 encryption key
in case the array was written with encryption.}

\item{timestamp}{optional A POSIXct Datetime value determining where in time the array is
to be openened. Deprecated, use \sQuote{timestamp_start} instead}

\item{as.matrix}{optional logical switch, defaults to "FALSE"; currently limited to dense
matrices; in the case of multiple attributes in query a list of matrices is returned}

\item{as.array}{optional logical switch, defaults to "FALSE"; in the case of multiple
attributes in query a list of arrays is returned}

\item{query_condition}{optional \code{tiledb_query_condition} object, by default uninitialized
without a condition; this functionality requires TileDB 2.3.0 or later}

\item{timestamp_start}{optional A POSIXct Datetime value determining the inclusive time point
at which the array is to be openened. No fragments written earlier will be considered.}

\item{timestamp_end}{optional A POSIXct Datetime value determining the inclusive time point
until which the array is to be openened. No fragments written earlier later be considered.}

\item{return_as}{optional A character value with the desired \code{tiledb_array} conversion,
permitted values are \sQuote{asis} (default, returning a list of columns), \sQuote{array},
\sQuote{matrix},\sQuote{data.frame}, \sQuote{data.table} or \sQuote{tibble}; the latter
two require the respective packages installed. The existing \code{as.*} arguments take precedent
over this.}

\item{ctx}{optional tiledb_ctx}
}
\value{
tiledb_array object
}
\description{
tiledb_array returns a new object. This class is experimental.
}
