% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubles.R
\name{double_equal}
\alias{double_equal}
\alias{double_gt}
\alias{double_gte}
\alias{double_lt}
\alias{double_lte}
\title{Double floating point comparison functions}
\usage{
double_equal(x, y, tol = sqrt(.Machine$double.eps))

double_gt(x, y, tol = sqrt(.Machine$double.eps))

double_gte(x, y, tol = sqrt(.Machine$double.eps))

double_lt(x, y, tol = sqrt(.Machine$double.eps))

double_lte(x, y, tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}

\item{tol}{A vector of tolerances.}
}
\value{
A logical vector.
}
\description{
Fast and efficient methods for comparing double floating point numbers
using relative differences.
}
\details{
When either \code{x[i]} or \code{y[i]} contain a number very close to zero,
absolute differences are used, otherwise relative differences are used.

The output of \code{double_equal()} is commutative, which means the order of arguments don't matter
whereas this is not the case for \code{all.equal.numeric()}.

The calculation is done in C++ and is quite efficient.
Recycling follows the usual R rules and is done without allocating
additional memory.
}
