% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_summarise.R
\name{q_summarise}
\alias{q_summarise}
\title{Fast grouped quantile summary}
\usage{
q_summarise(
  data,
  ...,
  probs = seq(0, 1, 0.25),
  type = 7,
  pivot = c("wide", "long"),
  na.rm = TRUE,
  sort = TRUE,
  .by = NULL,
  .cols = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Variables used to calculate quantiles for.
Tidy data-masking applies.}

\item{probs}{Quantile probabilities.}

\item{type}{An integer from 5-9 specifying which algorithm to use.
See \code{\link{quantile}} for more details.}

\item{pivot}{Should data be pivoted wide or long? Default is \code{wide}.}

\item{na.rm}{Should \code{NA} values be removed? Default is \code{TRUE}.}

\item{sort}{Should groups be sorted? Default is \code{TRUE}.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}
}
\value{
A \code{data.table} containing the quantile values for each group.
}
\description{
\code{collapse} and \code{data.table} are used for the calculations.
}
\examples{
library(timeplyr)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Standard quantiles
iris \%>\%
  q_summarise(Sepal.Length)
# Quantiles by species
iris \%>\%
  q_summarise(Sepal.Length, .by = Species)
# Quantiles by species across multiple columns
iris \%>\%
  q_summarise(Sepal.Length, Sepal.Width,
            probs = c(0, 1),
            .by = Species)
# Long format if one desires, useful for ggplot2
iris \%>\%
  q_summarise(Sepal.Length, pivot = "long",
            .by = Species)
# Example with lots of groups
set.seed(20230606)
df <- data.frame(x = rnorm(10^5),
                 g = sample.int(10^5, replace = TRUE))
q_summarise(df, x, .by = g, sort = FALSE)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
\seealso{
\link{stat_summarise}
}
