% Generated by roxygen2 (4.0.2): do not edit by hand
\name{storeTimeSeries}
\alias{storeTimeSeries}
\title{Write an R Time Series to a PostgreSQL database}
\usage{
storeTimeSeries(series, con = options()$TIMESERIESDB_CON, ts_key = NULL,
  tbl = "timeseries_main", lookup_env = .GlobalEnv, overwrite = T)
}
\arguments{
\item{series}{character name of a time series, S3 class ts}

\item{con}{a PostgreSQL connection object.}

\item{ts_key}{optional character string to specify an explicit time series primary key for the database. Defaults to NULL and uses the name of the R time series object as a key. Note that keys need to be unique in the database.}

\item{tbl}{character string denoting the name of the main time series table in the PostgreSQL database.}

\item{lookup_env}{environment to look in for timeseries. Defaults to .GobalEnv.
This option is particularly important when running storeTimeseries within loop like operations.}

\item{overwrite}{logical, whether time series should be overwritten in case a non-unique primary key is provided. Defaults to TRUE.}
}
\description{
This function writes time series object into a relational PostgreSQL database make use
of PostgreSQL own 'key'=>'value' storage called hstore. The schema and database needs to
created first. The parent R Package of this functions suggests a database structure
designed to store a larger amount of time series. This function uses INSERT INTO instead of the more convenient dbWritetable for performance reasons
}
\author{
Matthias Bannert, Gabriel Bucur
}

