% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_box_cox.R
\name{step_box_cox}
\alias{step_box_cox}
\alias{tidy.step_box_cox}
\title{Box-Cox Transformation using Forecast Methods}
\usage{
step_box_cox(
  recipe,
  ...,
  method = c("guerrero", "loglik"),
  limits = c(-1, 2),
  role = NA,
  trained = FALSE,
  lambdas_trained = NULL,
  skip = FALSE,
  id = rand_id("box_cox")
)

\method{tidy}{step_box_cox}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{method}{One of "guerrero" or "loglik"}

\item{limits}{A length 2 numeric vector defining the range to
compute the transformation parameter lambda.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{lambdas_trained}{A numeric vector of transformation values. This
is \code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_box_cox} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{value} (the
lambda estimate).
}
\description{
\code{step_box_cox} creates a \emph{specification} of a recipe
step that will transform data using a Box-Cox
transformation. This function differs from
\code{recipes::step_BoxCox} by adding multiple methods
including Guerrero lambda optimization and handling for
negative data used in the Forecast R Package.
}
\details{
The \code{step_box_cox()} function is designed specifically to handle time series
using methods implemented in the Forecast R Package.

\strong{Negative Data}

This function can be applied to Negative Data.

\strong{Lambda Optimization Methods}

This function uses 2 methods for optimizing the lambda selection
from the Forecast R Package:
\enumerate{
\item \code{method = "guerrero"}: Guerrero's (1993) method is used, where lambda minimizes
the coefficient of variation for subseries of x.
\item \code{method = loglik}: the value of lambda is chosen to maximize the profile
log likelihood of a linear model fitted to x. For non-seasonal data, a
linear time trend is fitted while for seasonal data, a linear time trend
with seasonal dummy variables is used.
}
}
\examples{
library(tidyverse)
library(tidyquant)
library(recipes)
library(timetk)

FANG_wide <- FANG \%>\%
select(symbol, date, adjusted) \%>\%
    pivot_wider(names_from = symbol, values_from = adjusted)

recipe_box_cox <- recipe(~ ., data = FANG_wide) \%>\%
    step_box_cox(FB, AMZN, NFLX, GOOG) \%>\%
    prep()

recipe_box_cox \%>\% bake(FANG_wide)

recipe_box_cox \%>\% tidy(1)

}
\references{
\enumerate{
\item Guerrero, V.M. (1993) Time-series analysis supported by power transformations. \emph{Journal of Forecasting}, \strong{12}, 37–48.
\item Box, G. E. P. and Cox, D. R. (1964) An analysis of transformations. \emph{JRSS} B \strong{26} 211–246.
}
}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{\link[recipes:step_lag]{recipes::step_lag()}}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Transformations to reduce variance:
\itemize{
\item \code{\link[recipes:step_log]{recipes::step_log()}} - Log transformation
\item \code{\link[recipes:step_sqrt]{recipes::step_sqrt()}} - Square-Root Power Transformation
}

Recipe Setup and Application:
\itemize{
\item Create: \code{\link[recipes:recipe]{recipes::recipe()}}
\item Prepare: \code{\link[recipes:prep.recipe]{recipes::prep.recipe()}}
\item Apply: \code{\link[recipes:bake.recipe]{recipes::bake.recipe()}}
}
}
