% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timsr.R
\name{[,TimsR,ANY,character-method}
\alias{[,TimsR,ANY,character-method}
\title{Get some frames of data.}
\usage{
\S4method{[}{TimsR,ANY,character}(x, i, j)
}
\arguments{
\item{x}{OpenTIMS data instance.}

\item{i}{An array of nonzero frame numbers to extract.}

\item{j}{A vector of strings with column names to extract.}
}
\value{
data.table
}
\description{
Get some frames of data.
}
\examples{
\dontrun{
D = TimsR('path/to/your/folder.d')
all_cols = c('frame','scan','tof','intensity',
             'mz','inv_ion_mobility','retention_time')
print(D[c(1,20, 53), all_cols]
# extracted all columns

print(D[c(1,20, 53), c('scan','intensity')]
# only 'scan' and 'intensity'
}
}
