% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{prSave}
\alias{prSave}
\alias{prLoad}
\title{Easily save and load data}
\usage{
prSave(name, replace = FALSE, desc = "No description", subdir = ".")

prLoad(name, subdir = ".", trace = TRUE, envir = .GlobalEnv)
}
\arguments{
\item{name}{Name of the object to save or to load. Quotes are optional. Optionaly, one
can also specify the subfolder where to save or load the object.}

\item{replace}{If the file already exists, should it be overwrited ? The prupose of this
parameter is to avoid some dramas. Use it with caution.}

\item{desc}{Short description of the object.}

\item{subdir}{subdirectory where to save or load the object.}

\item{trace}{Should information about the loaded object be printed ?}

\item{envir}{the environment where the object should be loaded. By default, it is the
global environement so that the object should be easily accessible in all
settings}
}
\description{
\code{prSave} and \code{prLoad} save and load data in the folder \code{data} 
of the project. Each object is saved in distinct file with the same name as
the object and the extension \code{rda}.
}
\examples{

projectPath <- file.path(tempdir(), "test")
prInit(projectPath)

test <- rnorm(100)
prSave(test)

list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

# Save again but add a description
prSave(test, replace = TRUE, desc = "Just a test !")

prLoad(test)

# It is also possible to save/load in subfolders
prSave(test, TRUE, subdir = "testdir", desc = "Saved in subfolder")
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

# Or equivalently
prSave("testdir/test", TRUE, desc = "Saved in subfolder")

prLoad(test, subdir="testdir")
prLoad("testdir/test")
  
}
\seealso{
\code{\link{prLibrary}}, \code{\link{prSource}}
}
