% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_misc.R
\name{import_LL}
\alias{import_LL}
\alias{import_int}
\title{Miscellaneous import_ - Functions}
\usage{
import_LL(package, selection, lib.loc = .libPaths())

import_int(form, lib.loc = .libPaths())
}
\arguments{
\item{package}{a single string,
giving the name of the package to take functions from. \cr
Core R (i.e. "base", "stats", etc.) is not allowed.}

\item{selection}{a character vector of function names
(both regular functions and infix operators). \cr
Internal functions or re-exported functions are not supported.}

\item{lib.loc}{character vector specifying library search path
(the location of R library trees to search through). \cr
The \code{lib.loc} argument would usually be \code{.libPaths()}. \cr
See also \link[base]{loadNamespace}.}

\item{form}{a two-sided formula, with one term on each side. \cr
The term on the left hand side should give a single package name. \cr
The term on the right hand side should give a single internal function. \cr
Example: \code{package_name ~ function_name} \cr
Core R (i.e. "base", "stats", etc.) is not allowed.}
}
\value{
For \code{import_LL()}: \cr
The specified functions will be placed in the current environment
(like the global environment, or the environment within a function),
and locked. \cr
To unexpose or overwrite the functions, simply remove them; i.e.: \cr
\code{rm(list=c("some_function1", "some_function2")}). \cr
\cr
For \code{import_int()}: \cr
The function itself is returned directly. \cr
So one can assign the function directly to some variable, like so: \cr
\code{myfun <- import_int(...)} \cr
or use it directly without re-assignment like so: \cr
\code{import_int(...)(...)}
}
\description{
The \code{import_LL()} function
places specific functions from a package in the current environment,
and also locks (see \link[base]{lockBinding}) the specified functions to prevent modification. \cr
The primary use-case for this function is for exposing functions inside a local environment,
like the environment within a function. \cr
\cr
The \code{import_int()} function
directly returns an internal function from a package. \cr
It is similar to the \link[base]{:::} operator, but with 2 key differences: \cr
\enumerate{
\item \code{import_int()} includes the \code{lib.loc} argument.
\item \code{import_int()} only searches internal functions, not exported ones.
This makes it clearer in your code that you're using an internal function,
instead of making it ambiguous. \cr \cr
}
}
\details{
\bold{Regarding the Locks in \code{import_LL()}} \cr
The \link{import_as} function returns a locked environment,
just like \link[base]{loadNamespace},
thus protecting the functions from accidental modification or re-assignment. \cr
The \link{import_inops} function returns infix operators,
and though these are not locked,
one needs to surround infix operators by back ticks to re-assign or modify them,
which is unlikely to happen on accident. \cr
The \code{import_LL()} function, however, returns "loose" functions.
And these functions
(unless they are infix operators)
do not have the protection due to a locked environment or due to the syntax. \cr
Therefore, to ensure safety from (accidental) modification or re-assignment,
the \code{import_LL()} function locks these functions (see \link[base]{lockBinding}).
For consistency, infix operators exposed by \code{import_LL()} are also locked. \cr
\cr
\bold{Other Details} \cr
The \code{import_LL()} and \code{import_int()} functions
do not support importing functions from base/core R. \cr
\cr
}
\examples{

# Using import_LL ====
import_LL(
  "stringi", "stri_sub"
)
# the stri_sub() function now cannot be modified, only used or removed, because it's locked:
bindingIsLocked("stri_sub", environment()) # TRUE

mypaste <- function(x, y) {
  import_LL("stringi", selection = "stri_c")
  stri_c(x, y)
  }
mypaste("hello ", "world")



# Using internal function ====
# Through re-assignment:
fun <- import_int(tinycodet ~ .internal_paste, .libPaths())
fun("hello", "world")

# Or using directly:
import_int(
  tinycodet ~ .internal_paste, .libPaths()
)("hello", "world")



}
\seealso{
\link{tinycodet_import}
}
