% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyscholar.R
\name{tinyscholar}
\alias{tinyscholar}
\title{Get Google Scholar Profile}
\usage{
tinyscholar(
  id,
  sortby_date = FALSE,
  use_cache = TRUE,
  cache_dir = file.path(tempdir(), "tinyscholar")
)
}
\arguments{
\item{id}{Your google scholar identifier. You can find it in the URL of your google scholar profile.}

\item{sortby_date}{Logical. If \code{TRUE}, the publications are sorted by date.}

\item{use_cache}{If \code{TRUE} (default), store data to a cache file to avoid querying in next time within a day.
The store file is identical for each person and each date.}

\item{cache_dir}{A directory path.}
}
\value{
a \code{Profile} object with list structure.
}
\description{
Get Google Scholar Profile
}
\examples{
# Put one unique Scholar ID from Google Scholar
r <- tinyscholar("FvNp0NkAAAAJ")
r
if (!is.null(r)) {
  tb <- scholar_table(r)
  tb$citations
  tb$publications
  pl <- scholar_plot(r)
  pl$citations
  pl$publications
}
}
