% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt.R
\name{tt}
\alias{tt}
\title{Draw a Tiny Table}
\usage{
tt(
  x,
  digits = NULL,
  caption = NULL,
  width = NULL,
  notes = NULL,
  theme = "default",
  placement = getOption("tinytable_tabularray_placement", default = NULL)
)
}
\arguments{
\item{x}{A data frame or data table to be rendered as a table.}

\item{digits}{Number of significant digits to keep for numeric variables. When \code{digits} is an integer, \code{tt()} calls \code{format_tt(x, digits = digits)} before proceeding to draw the table. Users who need more control can use the \code{format_tt()} function.}

\item{caption}{A string that will be used as the caption of the table.}

\item{width}{A numeric value between 0 and 1 indicating the proportion of the line width that the table should cover.}

\item{notes}{Notes to append to the bottom of the table. This argument accepts several different inputs:
\itemize{
\item Single string insert a single note: \code{"blah blah"}
\item Multiple strings insert multiple notes sequentially: \code{list("Hello world", "Foo bar")}
\item A named list inserts a list with the name as superscript: \code{list("a" = list("Hello World"))}
\item A named list with positions inserts markers as superscripts inside table cells: \code{list("a" = list(i = 0:1, j = 2, text = "Hello World"))}
}}

\item{theme}{The theme to apply to the table: "default", "striped", "bootstrap", "void", or "grid".}

\item{placement}{A string to control the position of tables in LaTeX. Will be inserted in square brackets like: \verb{\\\\begin\{table\}[H]}}
}
\value{
An object of class \code{tt} representing the table.

The table object has an attribute which holds information about the structure of the table. This metadata can be accessed with \code{attr(x,"tinytable_meta")}. In general, modifying the content of this attribute is not recommended, but it can be useful to some developers, such as those who want to force print to a specific output format without calling \code{print()}.
}
\description{
The \code{tt} function renders a table in different formats with various styling options: HTML, Markdown, LaTeX, Word, PDF, PNG, or Typst. The table can be customized with additional functions:
\itemize{
\item \code{style_tt()} to style fonts, colors, alignment, etc.
\item \code{format_tt()} to format numbers, dates, strings, etc.
\item \code{group_tt()} for row or column group labels.
\item \code{save_tt()} to save the table to a file or return the table as a string.
\item \code{print()} to print to a specific format, ex: \code{print(x, "latex")}
}

\code{tinytable} attempts to determine the appropriate way to print the table based on interactive use, RStudio availability, and output format in RMarkdown or Quarto documents. Users can call \code{print(x, output="markdown")} to print the table in a specific format. Alternatively, they can set a global option: \code{options("tinytable_print_output"="markdown")}
}
\section{LaTeX preamble}{


When rendering Quarto and Rmarkdown documents, \code{tinytable} will populate the LaTeX preamble automatically with all the required packages. For standalone LaTeX packages, these commands should be inserted in the preamble:

\if{html}{\out{<div class="sourceCode latex">}}\preformatted{\\usepackage\{tabularray\}
\\usepackage\{float\}
\\usepackage\{graphicx\}
\\usepackage\{codehigh\}
\\usepackage[normalem]\{ulem\}
\\UseTblrLibrary\{booktabs\}
\newcommand{\tinytableTabularrayUnderline}[1]\{\\underline\{#1\}\}
\newcommand{\tinytableTabularrayStrikeout}[1]\{\\sout\{#1\}\}
\\NewTableCommand\{\\tinytableDefineColor\}[3]\{\\definecolor\{#1\}\{#2\}\{#3\}\}
}\if{html}{\out{</div>}}
}

\examples{
library(tinytable)
x <- mtcars[1:4, 1:5]

tt(x)

tt(x,
   theme = "striped",
   width = 0.5,
   caption = "Data about cars.")

tt(x, notes = "Hello World!")

fn <- list(i = 0:1, j = 2, text = "Hello World!")
tab <- tt(x, notes = list("*" = fn))
print(tab, "latex")

}
