% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_tt.R
\name{group_tt}
\alias{group_tt}
\title{Spanning labels to identify groups of rows or columns}
\usage{
group_tt(x, i = NULL, j = NULL, indent = 1, ...)
}
\arguments{
\item{x}{A data frame or data table to be rendered as a table.}

\item{i}{A vector of labels with length equal to the number of rows in \code{x}, or a named list of row indices to group. The names of the list will be used as labels. The indices represent the position where labels should be inserted in the original table. For example,
\itemize{
\item \code{i=list("Hello"=5)}: insert the "Hello" label after the 4th row in the original table.
\item \code{i=list("Hello"=2, "World"=2)}: insert the two labels consecutively after the 1st row in the original table.
\item \code{i=list("Foo Bar"=0)}: insert the label in the first row after the header.
}}

\item{j}{A named list of column indices to group. The names of the list will be used as labels. See examples below. Note: empty labels must be a space: " ".}

\item{indent}{integer number of \code{pt} to use when indenting the non-labelled rows.}

\item{...}{Other arguments are ignored.}
}
\value{
An object of class \code{tt} representing the table.
}
\description{
Spanning labels to identify groups of rows or columns
}
\details{
Warning: The \code{style_tt()} can normally be used to style the group headers, as expected, but that feature is not available for Markdown and Word tables.
}
\section{Word and Markdown limitations}{


Markdown and Word tables only support these styles: italic, bold, strikeout. The \code{width} argument is also unavailable
Moreover, the \code{style_tt()} function cannot be used to style headers inserted by the \code{group_tt()} function;
instead, you should style the headers directly in the header definition using markdown syntax:
\code{group_tt(i = list("*italic header*" = 2))}. These limitations are due to the fact that there is no markdown
syntax for the other options, and that we create Word documents by converting a markdown table to .docx
via the Pandoc software.
}

\examples{

# vector of row labels
dat <- data.frame(
  label = c("a", "a", "a", "b", "b", "c", "a", "a"),
  x1 = rnorm(8),
  x2 = rnorm(8))
tt(dat[, 2:3]) |> group_tt(i = dat$label)

# named lists of labels
tt(mtcars[1:10, 1:5]) |>
  group_tt(
    i = list(
      "Hello" = 3,
      "World" = 8),
    j = list(
      "Foo" = 2:3,
      "Bar" = 4:5))

dat <- mtcars[1:9, 1:8]
tt(dat) |>
  group_tt(i = list(
    "I like (fake) hamburgers" = 3,
    "She prefers halloumi" = 4,
    "They love tofu" = 7))

tt(dat) |>
  group_tt(
    j = list(
      "Hamburgers" = 1:3,
      "Halloumi" = 4:5,
      "Tofu" = 7))

x <- mtcars[1:5, 1:6]
tt(x) |>
  group_tt(j = list("Hello" = 1:2, "World" = 3:4, "Hello" = 5:6)) |>
  group_tt(j = list("Foo" = 1:3, "Bar" = 4:6))

}
