% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tipmap_data.R
\name{create_tipmap_data}
\alias{create_tipmap_data}
\title{Create data frame ready to use for tipping point analysis}
\usage{
create_tipmap_data(new_trial_data, posterior, map_prior, meta_analysis = NULL)
}
\arguments{
\item{new_trial_data}{A data frame containing data on the new trial in the target population. See \code{create_new_trial_data()}.}

\item{posterior}{A mixture combining MAP prior and target population. See \code{create_posterior_data()}.}

\item{map_prior}{A robust MAP prior created by \code{RBesT::automixfit()}.}

\item{meta_analysis}{A data frame containing a meta-analysis of trial(s) to be borrowed from. See \code{createPriorData()}.}
}
\value{
A data frame ready to be used for \code{tipmap_plot()} and \code{get_tipping_point()}
}
\description{
Combines new trial data created by \code{createTargetData()}, a posterior distribution created by \code{create_posterior_data()} and a
robust MAP prior using \code{RBesT::automixfit()} and an optional meta-analysis, e.g. created using the \code{meta} package, into a data frame
needed for the functions \code{tipmap_plot()} and \code{get_tipping_point()}.
}
\examples{

# specify new trial data
new_trial_data <- create_new_trial_data(n_total = 30, est = 1.5, se = 2.1)

# read MAP prior data
map_prior <- load_tipmap_data("tipmapPrior.rds")

# read posterior data
posterior <- load_tipmap_data("tipPost.rds")

tip_dat <- create_tipmap_data(
  new_trial_data = new_trial_data,
  posterior = posterior,
  map_prior = map_prior
)

}
\seealso{
\code{\link{create_new_trial_data}}, \code{\link{create_posterior_data}}, \code{\link{tipmap_plot}}, \code{\link{get_tipping_point}}
}
