% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_hr_with_binary}
\alias{adjust_hr_with_binary}
\title{Adjust an observed hazard ratio with a binary confounder}
\usage{
adjust_hr_with_binary(
  effect_observed,
  exposed_p,
  unexposed_p,
  confounder_outcome_effect,
  verbose = TRUE,
  hr_correction = FALSE
)
}
\arguments{
\item{effect_observed}{Numeric positive value. Observed exposure - outcome hazard ratio.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{exposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{confounder_outcome_effect}{Numeric positive value. Estimated relationship
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{hr_correction}{Logical. Indicates whether to use a correction factor.
The methods used for this function are based on relative risks. For rare
outcomes, a hazard ratio approximates a relative risk. For common outcomes,
a correction factor is needed. If you have a common outcome (>15\%),
set this to \code{TRUE}. Default: \code{FALSE}.}
}
\value{
Data frame.
}
\description{
Adjust an observed hazard ratio with a binary confounder
}
\examples{
adjust_hr_with_binary(0.8, 0.1, 0.5, 1.8)
}
