% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_rr}
\alias{adjust_rr}
\alias{adjust_rr_with_continuous}
\title{Adjust an observed relative risk for a normally distributed
confounder}
\usage{
adjust_rr(
  effect_observed,
  exposure_confounder_effect,
  confounder_outcome_effect,
  verbose = TRUE
)

adjust_rr_with_continuous(
  effect_observed,
  exposure_confounder_effect,
  confounder_outcome_effect,
  verbose = TRUE
)
}
\arguments{
\item{effect_observed}{Numeric positive value. Observed exposure - outcome relative risk.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{exposure_confounder_effect}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{confounder_outcome_effect}{Numeric. Estimated relationship
between the unmeasured confounder and the outcome.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\value{
Data frame.
}
\description{
Adjust an observed relative risk for a normally distributed
confounder
}
\examples{
adjust_rr(1.2, 0.5, 1.1)
}
