% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_km.R
\name{average_km}
\alias{average_km}
\title{Average Kaplan-Meier Curves Across Multiple Imputed Datasets}
\usage{
average_km(km_data, arm, conf_level = 0.95)
}
\arguments{
\item{km_data}{List of data frames, each containing one multiply imputed dataset for a tipping point.
Each data frame must contain columns \code{AVAL}, \code{EVENT}, \code{TRT01P}, \code{iter}, and a tipping point parameter depending on the method.}

\item{arm}{Character string specifying the treatment arm to pool (must match \code{TRT01P} levels).}

\item{conf_level}{Numeric. Confidence level for CIs (default = 0.95).}
}
\value{
A data frame with the following columns:
\describe{
\item{time}{Time points of the KM curve.}
\item{survival_comb}{Pooled survival probability at each time point.}
\item{survival_lcl_comb}{Lower 95\% confidence limit of pooled survival.}
\item{survival_ucl_comb}{Upper 95\% confidence limit of pooled survival.}
\item{stderr}{Standard error of the pooled log-log transformed estimate.}
}
}
\description{
Takes a list of multiply imputed datasets corresponding to a single tipping point
parameter and pools the Kaplan-Meier survival curves for a given treatment arm.
Uses log(-log) transformation and Rubin's rules for pooling across imputations.
}
\keyword{internal}
