% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minhash_v2.R
\name{extract_pairs_from_band}
\alias{extract_pairs_from_band}
\title{Function that extracts pairs of records from a band in the signature matrix M
import bit64}
\usage{
extract_pairs_from_band(a_band)
}
\arguments{
\item{a_band}{Band of the signature matrix M}
}
\value{
The edgelist of record pairs that are connected
}
\description{
Function that extracts pairs of records from a band in the signature matrix M
import bit64
}
\examples{
band1 <- c(2,1,2,1,2)
extract_pairs_from_band(band1)
band2 <- c(6,7,8,9,6)
extract_pairs_from_band(band2)
band.12 <- rbind(band1, band2)
apply(band.12,1,extract_pairs_from_band)
}
