% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_14_kRp.corpus-class_docTermMatrix.R
\docType{methods}
\name{docTermMatrix,kRp.corpus-method}
\alias{docTermMatrix,kRp.corpus-method}
\alias{docTermMatrix,-methods}
\title{Generate a document-term matrix from a corpus object}
\usage{
\S4method{docTermMatrix}{kRp.corpus}(
  obj,
  terms = "token",
  case.sens = FALSE,
  tfidf = FALSE,
  as.feature = TRUE
)
}
\arguments{
\item{obj}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{terms}{A character string defining the \code{tokens} column to be used for calculating the matrix.}

\item{case.sens}{Logical, whether terms should be counted case sensitive.}

\item{tfidf}{Logical,
      if \code{TRUE} calculates term frequency--inverse document frequency (tf-idf)
values instead of absolute frequency.}

\item{as.feature}{Logical,
      whether the output should be just the sparse matrix or the input object with
that matrix added as a feature. Use \code{\link[tm.plugin.koRpus:corpusDocTermMatrix]{corpusDocTermMatrix}}
to get the matrix from such an aggregated object.}
}
\value{
Either an object of the input class or a sparse matrix of class
   \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}.
}
\description{
Calculates a sparse document-term matrix calculated from a given object of class
\code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}} and adds it to the object's feature list.
You can also calculate the term frequency inverted document frequency value (tf-idf) for each
term.
}
\details{
The settings of \code{terms}, \code{case.sens},
      and \code{tfidf} will be stored in the object's \code{meta} slot,
so you can use \code{corpusMeta(..., "doc_term_matrix")} to fetch it.

See the examples to learn how to limit the analysis to desired word classes.
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(path.package("tm.plugin.koRpus"), "examples", "corpus"),
    hierarchy=list(
      Topic=c(
        Winner="Reality Winner",
        Edwards="Natalie Edwards"
      ),
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  # get the document-term frequencies in a sparse matrix
  myDTMatrix <- docTermMatrix(myCorpus, as.feature=FALSE)

  # combine with filterByClass() to, e.g.,  exclude all punctuation
  myDTMatrix <- docTermMatrix(filterByClass(myCorpus), as.feature=FALSE)

  # instead of absolute frequencies, get the tf-idf values
  myDTMatrix <- docTermMatrix(
    filterByClass(myCorpus),
    tfidf=TRUE,
    as.feature=FALSE
  )
} else {}
}
