\name{writeCorpus}
\alias{writeCorpus}
\title{Write a Corpus to Disk}
\description{
  Write a plain text representation of a corpus to multiple files on
  disk corresponding to the individual documents in the corpus.
}
\usage{
writeCorpus(x, path = ".", filenames = NULL)
}
\arguments{
  \item{x}{A corpus.}
  \item{path}{A character listing the directory to be written into.}
  \item{filenames}{Either \code{NULL} or a character vector. In case no
    filenames are provided, filenames are automatically generated by
    using the documents' ID strings in \code{x}.}
}
\examples{
data("crude")
\dontrun{
writeCorpus(crude, path = ".",
            filenames = paste(seq_along(crude), ".txt", sep = ""))
}
}
