% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convert_shape_data.R
\name{convert_shape_data}
\alias{convert_shape_data}
\title{Convert shape data}
\usage{
convert_shape_data(shp.from, shp.to, variables.from = NULL,
  variables.to = NULL)
}
\arguments{
\item{shp.from}{the shape object, i.e. a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}, to be converted. It should contain data.}

\item{shp.to}{the shape object, i.e. a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}, to be converted into.}

\item{variables.from}{names of the numeric variables of \code{shp.from} to be converted. If missing, all numeric variables are taken.}

\item{variables.to}{variable names to be used. Should be the same number of variable names as \code{variables.from}}
}
\value{
Shape object \code{shp.to} with converted data from \code{shp.from}.
}
\description{
Convert numeric data from one polygon shape to another. It uses an intersection matrix, which stores the intersection ratios of the two shape objects per polygon (see \code{\link{intersection_shapes}}).
}
\note{
Running time may be pretty slow.
}
\examples{
\dontrun{
data(NLD_prov)
data(NLD_muni)

## Compare to the original province population data
qtm(NLD_muni, fill="population", convert2density = TRUE)
qtm(NLD_prov, fill="population", convert2density = TRUE)

## For illustration, the population of provinces is derived from the municipality data
NLD_prov <- convert_shape_data(NLD_muni, NLD_prov, variables.from = "population")
qtm(NLD_prov, fill="population.data", convert2density = TRUE)

## Now, the population of province level is spread equally over the municipalities
NLD_muni <- convert_shape_data(NLD_prov, NLD_muni, variables.from = "population")
qtm(NLD_muni, fill="population.data", convert2density = TRUE)
}
}

