% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_raster}
\alias{tm_raster}
\title{Draw a raster}
\usage{
tm_raster(col = NA, alpha = NA, palette = NULL, n = 5,
  style = ifelse(is.null(breaks), "pretty", "fixed"), breaks = NULL,
  labels = NULL, auto.palette.mapping = TRUE, contrast = NA,
  max.categories = 12, colorNA = NULL, saturation = 1,
  textNA = "Missing", showNA = NA, title = NA, legend.show = TRUE,
  legend.format = list(), legend.is.portrait = TRUE, legend.hist = FALSE,
  legend.hist.title = NA, legend.z = NA, legend.hist.z = NA)
}
\arguments{
\item{col}{three options: a single color value, the name of a data variable that is contained in \code{shp}, or the name of a variable in \code{shp} that contain color values. In the second case the values (numeric or categorical) that will be depicted by a color palette (see \code{palette}. If omitted, and if \code{shp} contains three numeric layers that range between 0 and 255, these are interpreted as RGB values, else, the first data variable is selected.
If multiple values are specified, small multiples are drawn (see details). By default, it is the name of the first data variable.}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{palette}{palette name. See \code{RColorBrewer::display.brewer.all()} for options. Use a \code{"-"} as prefix to reverse the palette. The default palette is taken from \code{\link{tm_layout}}'s argument \code{aes.palette}.}

\item{n}{preferred number of classes (in case \code{col} is a numeric variable)}

\item{style}{method to process the color scale when \code{col} is a numeric variable. Discrete options are \code{"cat"}, \code{"fixed"}, \code{"sd"}, \code{"equal"}, \code{"pretty"}, \code{"quantile"}, \code{"kmeans"}, \code{"hclust"}, \code{"bclust"}, \code{"fisher"}, and \code{"jenks"}. A numeric variable is processed as a categorial variable when using \code{"cat"}, i.e. each unique value will correspond to a distinct category. For the other discrete options, see the details in \code{\link[classInt:classIntervals]{classIntervals}}. Continuous options are "cont" and "order". The former maps the values of \code{col} to a smooth gradient, whereas the latter maps the order of values of \code{col} to a smooth gradient. They are the continuous variants of respectively the discrete methods "equal" and quantile".}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values. When categorical color palettes are used, this method stretches the palette is there are more levels than colors.}

\item{contrast}{vector of two numbers that determine the range that is used for sequential and diverging palettes (applicable when \code{auto.palette.mapping=TRUE}). Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the brightest color, and 1 the darkest color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories} and \code{auto.palette.mapping} is \code{FALSE}, then levels are combined.}

\item{colorNA}{color used for missing values. Use \code{NULL} for transparency.}

\item{saturation}{Number that determines how much saturation (also known as chroma) is used: \code{saturation=0} is greyscale and \code{saturation=1} is normal. This saturation value is multiplied by the overall saturation of the map (see \code{\link{tm_layout}}).}

\item{textNA}{text used for missing values.}

\item{showNA}{logical that determines whether missing values are named in the legend. By default (\code{NA}), this depends on the presence of missing values.}

\item{title}{title of the legend element}

\item{legend.show}{logical that determines whether the legend is shown}

\item{legend.format}{list of formatting options for the legend numbers. Only applicable if \code{labels} is undefined. Parameters are:
\describe{
\item{scientific}{Should the labels be formatted scientically? If so, square brackets are used, and the \code{format} of the numbers is \code{"g"}. Otherwise, \code{format="f"}, and \code{text.separator}, \code{text.less.than}, and \code{text.or.more} are used. Also, the numbers are automatically  rounded to millions or billions if applicable.}
\item{format}{By default, \code{"f"}, i.e. the standard notation \code{xxx.xxx}, is used. If \code{scientific=TRUE} then \code{"g"}, which means that numbers are formatted scientically, i.e. \code{n.dddE+nn} if needed to save space.}
\item{digits}{Number of digits after the decimal point if \code{format="f"}, and the number of significant digits otherwise.}
\item{text.separator}{Character string to use to separate numbers in the legend (default: "to").}
\item{text.less.than}{Character string to use to translate "Less than" (which is the default).}
\item{text.or.more}{Character string to use to translate "or more" (which is the default). }
\item{...}{Other arguments passed on to \code{\link[base:formatC]{formatC}}}
}}

\item{legend.is.portrait}{logical that determines whether the legend is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.hist}{logical that determines whether a histogram is shown}

\item{legend.hist.title}{title for the histogram. By default, one title is used for both the histogram and the normal legend.}

\item{legend.z}{index value that determines the position of the legend element with respect to other legend elements. The legend elements are stacked according to their z values. The legend element with the lowest z value is placed on top.}

\item{legend.hist.z}{index value that determines the position of the histogram legend element}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draws a raster. For coloring, there are three options: 1) a fixed color is used, 2) a color palette is mapped to a data variable, 3) RGB values are used.
}
\details{
Small multiples can be drawn in two ways: either by specifying the \code{by} argument in \code{\link{tm_facets}}, or by defining multiple variables in the aesthetic arguments. The aesthetic argument of \code{tm_raster} is \code{col}. In the latter case, the arguments, except for \code{thres.poly}, and the ones starting with \code{legend.}, can be specified for small multiples as follows. If the argument normally only takes a single value, such as \code{n}, then a vector of those values can be specified, one for each small multiple. If the argument normally can take a vector, such as \code{palette}, then a list of those vectors (or values) can be specified, one for each small multiple.
}
\examples{
data(World, land, metro)

pal8 <- c("#33A02C", "#B2DF8A", "#FDBF6F", "#1F78B4", "#999999", "#E31A1C", "#E6E6E6", "#A6CEE3")
tm_shape(land, ylim = c(-88,88)) +
    tm_raster("cover_cls", palette = pal8, title="Global Land Cover") +
tm_shape(metro) + tm_dots(col="#E31A1C") +
tm_shape(World) +
    tm_borders(col="black") +
tm_layout(scale=.8, 
	legend.position = c("left","bottom"),
    legend.bg.color = "white", legend.bg.alpha=.2, 
    legend.frame="gray50")

\dontrun{
pal20 <- c("#003200", "#3C9600", "#006E00", "#556E19", "#00C800", "#8CBE8C",
		   "#467864", "#B4E664", "#9BC832", "#EBFF64", "#F06432", "#9132E6",
		   "#E664E6", "#9B82E6", "#B4FEF0", "#646464", "#C8C8C8", "#FF0000",
		   "#FFFFFF", "#5ADCDC")
tm_shape(land) +
	tm_raster("cover", max.categories = 20, palette=pal20, title="Global Land Cover") + 
	tm_layout(scale=.8, legend.position = c("left","bottom"))
}


tm_shape(land, ylim = c(-88,88)) +
    tm_raster("trees", palette = "Greens", title="Percent Tree Cover") +
tm_shape(World) +
    tm_borders() +
tm_layout(legend.position = c("left","bottom"), bg.color="lightblue")

# TIP: check out these examples in view mode, enabled with tmap_mode("view")

\dontrun{
# doesn't work in view mode, since it does not support small multiples
tm_shape(land) +
	tm_raster("black") +
	tm_facets(by="cover_cls")
}
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

