% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmapScale_defaults.R
\name{tm_seq}
\alias{tm_seq}
\title{Specify a numeric sequence}
\usage{
tm_seq(
  from = 0,
  to = 1,
  power = c("lin", "sqrt", "sqrt_perceptual", "quadratic")
)
}
\arguments{
\item{from, to}{The numeric range, default 0 and 1 respectively}

\item{power}{The power component, or one of \code{"lin"}, \code{"sqrt"}, \code{"sqrt_perceptual"}, \code{"quadratic"}, which correspond to 1, 0.5, 0.5716, 2 respectively. See details.}
}
\description{
Specify a numeric sequence, for numeric scales like \code{\link[=tm_scale_continuous]{tm_scale_continuous()}}. This function is needed when there is a non-linear relationship between the numeric data values and the visual variables. E.g. to make relationship with the area of bubbles linear, the square root of input variables should be used to calculate the radius of the bubbles.
}
\details{
The perceived area of larger symbols is often underestimated. Flannery (1971) experimentally derived a method to compensate this for symbols. This compensation is obtained by using the power exponent of 0.5716 instead of 0.5, or by setting \code{power} to \code{"sqrt_perceptual"}
}
