% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_osm.R
\name{read_osm}
\alias{read_osm}
\title{Read Open Street Map data}
\usage{
read_osm(x, zoom = NULL, type = "osm", minNumTiles = NULL,
  mergeTiles = NULL, use.colortable = FALSE, raster, ...)
}
\arguments{
\item{x}{object that can be coerced to a bounding box with \code{\link{bb}} (e.g. an existing bounding box or a shape). In the first case, other arguments can be passed on to \code{\link{bb}} (see \code{...}). If an existing bounding box is specified in projected coordinates, plesae specify \code{current.projection}.}

\item{zoom}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}}. Only applicable when \code{raster=TRUE}.}

\item{type}{tile provider, by default \code{"osm"}, which corresponds to OpenStreetMap Mapnik. See \code{\link[OpenStreetMap:openmap]{openmap}} for options. Only applicable when \code{raster=TRUE}.}

\item{minNumTiles}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}} Only applicable when \code{raster=TRUE}.}

\item{mergeTiles}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}} Only applicable when \code{raster=TRUE}.}

\item{use.colortable}{should the colors of the returned raster object be stored in a \code{\link[raster:colortable]{colortable}}? If \code{FALSE}, a RasterStack is returned with three layers that correspond to the red, green and blue values betweeen 0 and 255.}

\item{raster}{deprecated}

\item{...}{arguments passed on to \code{\link{bb}}.}
}
\value{
The output of \code{read_osm} is a \code{\link[raster:raster]{raster}} object.
}
\description{
Read Open Street Map data. OSM tiles are read and returned as a spatial raster. Vectorized OSM data is not supported anymore (see details).
}
\details{
As of version 2.0, \code{read_osm} cannot be used to read vectorized OSM data anymore. The reason is that the package that was used under the hood, \code{osmar}, has some limitations and is not actively maintained anymore. Therefore, we recommend the package \code{osmdata}. Since this package is very user-friendly, there was no reason to use \code{read_osm} as a wrapper for reading vectorized OSM data.
}
\examples{
\dontrun{
if (require(tmap)) {
    #### Choropleth with OSM background

    # load Netherlands shape
    data(NLD_muni)

    # read OSM raster data
    osm_NLD <- read_osm(NLD_muni, ext=1.1)

    # plot with regular tmap functions
    tm_shape(osm_NLD) +
    	tm_rgb() +
    tm_shape(NLD_muni) +
    	tm_polygons("population", convert2density=TRUE, style="kmeans", alpha=.7, palette="Purples")

    #### A close look at the building of Statistics Netherlands in Heerlen

    # create a bounding box around the CBS (Statistics Netherlands) building
    CBS_bb <- bb("CBS Weg 11, Heerlen", width=.003, height=.002)

    # read Microsoft Bing satellite and OpenCycleMap OSM layers
    CBS_osm1 <- read_osm(CBS_bb, type="bing")
    CBS_osm2 <- read_osm(CBS_bb, type="opencyclemap")

    # plot OSM raster data
    qtm(CBS_osm1)
    qtm(CBS_osm2)

}
}
}
