% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotwidgets.R
\name{simplePie}
\alias{simpleBoxpie}
\alias{simplePie}
\alias{simpleRug}
\title{Simple Pie Chart}
\usage{
simplePie(x, y, w, h, v, col, res = 100, border = NA)

simpleRug(x, y, w, h, v, col, border = NULL)

simpleBoxpie(x, y, w, h, v, col, border = NA, grid = 3)
}
\arguments{
\item{x, y}{coordinates at which to draw the plot}

\item{w, h}{width and height of the plot}

\item{v}{sizes of the slices}

\item{col}{colors of the slices}

\item{res}{resolution (number of polygon edges in a full circle)}

\item{border}{color of the border. Use NA (default) or NULL for no border}

\item{grid}{boxpie only: the grid over which the areas are distributed.
Should be roughly equal to the number of areas shown.}
}
\description{
The simplePie function draws a simple pie chart at specified coordinates with
specified width, height and color. The simpleRug function draws a
corresponding rug plot, while simpleBoxpie creates a "rectangular pie
chart" that is considered to be better legible than the regular pie.
}
\details{
simplePie() draws a pie chart with width w and height h at coordinates
(x,y). The size of the slices is taken from the numeric vector v, and
their color from the character vector col.
}
\examples{
# demonstration of the three widgets
plot.new()
par(usr=c(0,3,0,3))
x <- c(7, 5, 11)
col <- tmodPal()
b <- "black"
simpleRug(0.5, 1.5, 0.8, 0.8, v=x, col=col, border=b)
simplePie(1.5, 1.5, 0.8, 0.8, v=x, col=col, border=b)
simpleBoxpie(2.5, 1.5, 0.8, 0.8, v=x, col=col, border=b)

# using pie as plotting symbol
plot(NULL, xlim=1:2, ylim=1:2, xlab="", ylab="")
col <- c("#cc000099", "#0000cc99")
for(i in 1:125) { 
  x <- runif(1) + 1 
  y <- runif(1) + 1
  simplePie( x, y, 0.05, 0.05, c(x,y), col)
}

# square filled with box pies
n <- 10 
w <- h <- 1/(n+1)
plot.new()
for(i in 1:n) for(j in 1:n) 
 simpleBoxpie(1/n*(i-1/2), 1/n*(j-1/2), w, h, 
 v=runif(3), col=tmodPal())
}

