% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmvn.R
\name{rtmvn}
\alias{rtmvn}
\title{Random number generation for truncated multivariate normal distribution subject to linear inequality constraints}
\usage{
rtmvn(
  n,
  Mean,
  Sigma,
  D = diag(1, length(Mean)),
  lower,
  upper,
  int = NULL,
  burn = 10,
  thin = 1
)
}
\arguments{
\item{n}{number of random samples desired (sample size).}

\item{Mean}{mean vector of the underlying multivariate normal distribution.}

\item{Sigma}{positive definite covariance matrix of the underlying multivariate normal distribution.}

\item{D}{matrix or vector of coefficients of linear inequality constraints.}

\item{lower}{vector of lower bounds for truncation.}

\item{upper}{vector of upper bounds for truncation.}

\item{int}{initial value vector for Gibbs sampler (satisfying truncation), if \code{NULL} then determine automatically.}

\item{burn}{burn-in iterations discarded (default as \code{10}).}

\item{thin}{thinning lag (default as \code{1}).}
}
\value{
\code{rtmvn} returns a (\code{n*p}) matrix (or vector when \code{n=1}) containing random numbers which approximately follows truncated multivariate  normal distribution.
}
\description{
\code{rtmvn} simulates truncated multivariate (p-dimensional) normal distribution subject to linear inequality constraints. The constraints should be written as a matrix (\code{D}) with \code{lower} and \code{upper} as the lower and upper bounds for those constraints respectively. Note that \code{D} can be non-full rank, which generalize many traditional methods.
}
\examples{
# Example for full rank with strong dependence
d <- 3
rho <- 0.9
Sigma <- matrix(0, nrow=d, ncol=d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

D1 <- diag(1,d) # Full rank

set.seed(1203)
ans.1 <- rtmvn(n=1000, Mean=1:d, Sigma, D=D1, lower=rep(-1,d), upper=rep(1,d),
int=rep(0,d), burn=50)

apply(ans.1, 2, summary)

# Example for non-full rank
d <- 3
rho <- 0.5
Sigma <- matrix(0, nrow=d, ncol=d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

D2 <- matrix(c(1,1,1,0,1,0,1,0,1),ncol=d)
qr(D2)$rank # 2

set.seed(1228)
ans.2 <- rtmvn(n=100, Mean=1:d, Sigma, D=D2, lower=rep(-1,d), upper=rep(1,d), burn=10)

apply(ans.2, 2, summary)

}
