% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntp_colors.R
\name{tntp_colors}
\alias{tntp_colors}
\alias{show_tntp_colors}
\title{TNTP Brand Colors}
\usage{
tntp_colors(...)

show_tntp_colors(
  ...,
  pattern = NULL,
  labels = TRUE,
  borders = NULL,
  cex_label = 1,
  ncol = NULL
)
}
\arguments{
\item{...}{Supply quoted TNTP color names to return. If no colors are specified, returns all available colors.}

\item{pattern}{Optional regular expression. If provided, will return only brand colors that match the regular expression}

\item{labels}{Logical. Label colors with names and hex values?}

\item{borders}{Border color for each tile. Default uses \code{par("fg")}. Use \code{border = NA} to omit borders.}

\item{cex_label}{Size of printed labels, as multiplier of default size.}

\item{ncol}{Number of columns. If not supplied, tries to be as square as possible.}
}
\value{
\itemize{
\item \code{tntp_colors()} returns a character vector of color codes
\item \code{show_tntp_colors()} returns nothing
}
}
\description{
Translate human friendly TNTP brand color names like "medium_blue" into
accurate hex values for use in plotting. This function can also be used to
show a named vector of all available TNTP brand colors and values. Use
\code{show_tntp_colors()} to quickly visualize selected colors in the plot window.
For often used palettes of TNTP colors, see \code{\link[=tntp_palette]{tntp_palette()}}.
}
\examples{

library(ggplot2)

# Use tntp_colors() to retrieve a single color...
ggplot(mtcars, aes(wt, mpg)) +
  geom_point(color = tntp_colors('green'))

#... multiple colors ...
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() +
  scale_color_manual(values = tntp_colors('green', 'navy', 'red'))

#... or a list of all possible TNTP brand colors
tntp_colors()

# Use show_tntp_colors() to quickly see brand colors in the plotting window
show_tntp_colors('mint', 'moss', 'green')

# You can also use a pattern to return similar colors
show_tntp_colors(pattern = 'green')

# You can see all colors (and names) by running it with no arguments
show_tntp_colors()
}
