% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeKmeans.R
\name{computeSilhouette}
\alias{computeSilhouette}
\title{Compute Silhouette (k-means clustering).}
\usage{
computeSilhouette(channel, km, scaled = TRUE, silhouetteTableName = NULL,
  drop = TRUE, test = FALSE)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}.}

\item{km}{an object of class \code{"toakmeans"} obtained with \code{computeKmeans}.}

\item{scaled}{logical: indicates if computation performed on original (default) or scaled values.}

\item{silhouetteTableName}{name of the Aster table to hold silhouette scores. The table persists silhoutte scores 
for all clustered elements. Set parameter \code{drop=F} to keep the table.}

\item{drop}{logical: indicates if the table \code{silhouetteTableName}}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}
}
\value{
\code{computeSilhouette} returns an object of class \code{"toakmeans"} (compatible with class \code{"kmeans"}).
  It adds a named list \code{sil} the \code{km} containing couple of elements: average value of silhouette \code{value} and silhouette profile  
  (distribution of silhouette values on each cluster) \code{profile}
}
\description{
Compute Silhouette (k-means clustering).
}
\examples{
if(interactive()){
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")
                         
km = computeKmeans(conn, "batting", centers=5, iterMax = 25,
                   aggregates = c("COUNT(*) cnt", "AVG(g) avg_g", "AVG(r) avg_r", "AVG(h) avg_h"),
                   id="playerid || '-' || stint || '-' || teamid || '-' || yearid", 
                   include=c('g','r','h'), scaledTableName='kmeans_test_scaled', 
                   centroidTableName='kmeans_test_centroids',
                   where="yearid > 2000")
km = computeSilhouette(conn, km)
km$sil
createSilhouetteProfile(km, title="Cluster Silhouette Histograms (Profiles)")
}
}
\seealso{
\code{\link{computeKmeans}}
}

