% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagrid.R
\name{datagrid}
\alias{datagrid}
\title{Interactive tables with tui-grid}
\usage{
datagrid(
  data = list(),
  ...,
  sortable = TRUE,
  pagination = NULL,
  filters = FALSE,
  colnames = NULL,
  colwidths = "fit",
  align = "auto",
  theme = c("clean", "striped", "default"),
  draggable = FALSE,
  data_as_input = FALSE,
  contextmenu = FALSE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} or something convertible in \code{data.frame}.}

\item{...}{Arguments passed to the \code{Grid} \href{https://nhn.github.io/tui.grid/latest/Grid/}{JavaScript method}.}

\item{sortable}{Logical, allow to sort columns.}

\item{pagination}{Number of rows per page to display, default to \code{NULL} (no pagination).}

\item{filters}{Logical, allow to filter columns.}

\item{colnames}{Alternative colnames to be displayed in the header.}

\item{colwidths}{Width for the columns, can be \code{"auto"} (width is determined by column's content)
or a single or numeric vector to set the width in pixel. Use \code{NULL} to disable and use default behavior.}

\item{align}{Alignment for columns content: \code{"auto"} (numeric and date on right, other on left), \code{"right"},
\code{"center"} or \code{"left"}. Use \code{NULL} to ignore.}

\item{theme}{Predefined theme to be used.}

\item{draggable}{Whether to enable to drag the row for changing the order of rows.}

\item{data_as_input}{Should the \code{data} be available in an input \verb{input$<ID>_data} server-side?}

\item{contextmenu}{Display or not a context menu when using right click in the grid.
Can also be a list of custom options, see \href{https://nhn.github.io/tui.grid/latest/tutorial-example27-export/}{tui-grid documentation}
for examples.}

\item{width, height}{Width and height of the table in a CSS unit or a numeric.}

\item{elementId}{Use an explicit element ID for the widget.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Create interactive tables : sortable, filterable,
editable with the JavaScript library \href{https://ui.toast.com/tui-grid/}{tui-grid}.
}
\examples{
library(toastui)

# default usage
datagrid(rolling_stones_50)

# Column's width alternatives (default is "fit")
datagrid(rolling_stones_50, colwidths = "guess")
datagrid(rolling_stones_50, colwidths = "auto")
datagrid(rolling_stones_50, colwidths = NULL)

# disable sorting
datagrid(rolling_stones_50, sortable = FALSE)

# enable default filtering
datagrid(rolling_stones_50, filters = TRUE)

# enable pagination (10 rows per page)
datagrid(rolling_stones_50, pagination = 10)

# Themes
datagrid(rolling_stones_50, theme = "striped")
datagrid(rolling_stones_50, theme = "default")


# Empty table
datagrid(list())

# Empty columns
datagrid(data.frame(
  variable_1 = character(0),
  variable_2 = character(0)
))

# Specify colnames
datagrid(
  data = data.frame(
    variable_1 = sample(1:50, 12),
    variable_2 = month.name
  ),
  colnames = c("Number", "Month of the year")
)

}
\seealso{
\code{\link[=datagridOutput]{datagridOutput()}} / \code{\link[=renderDatagrid]{renderDatagrid()}} for usage in Shiny applications.
}
