% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{adaptive_MC_sampling}
\alias{adaptive_MC_sampling}
\title{Perform Adaptive Monte Carlo Sampling}
\usage{
adaptive_MC_sampling(
  samples_file,
  distance_matrix,
  iterations = 1,
  batch_size = 1,
  mapping_max_iter,
  relative_epsilon,
  folds = 20,
  num_cores = 1,
  scenario_name,
  verbose = FALSE
)
}
\arguments{
\item{samples_file}{Path to CSV with initial samples for this job.}

\item{distance_matrix}{Distance matrix to fit}

\item{iterations}{Number of sampling iterations per job}

\item{batch_size}{Samples per iteration (fixed to 1)}

\item{mapping_max_iter}{Maximum map optimization iterations}

\item{relative_epsilon}{Convergence threshold}

\item{folds}{Number of CV folds}

\item{num_cores}{Number of cores for parallel processing}

\item{scenario_name}{Name for output files}

\item{verbose}{Logical. Whether to print progress messages. Default: FALSE}
}
\value{
A \code{data.frame} containing all samples (initial and newly generated)
with their parameters and evaluated performance metrics. The data frame includes
columns for the log-transformed parameters, \code{Holdout_MAE}, and \code{NLL}.
Returns \code{NULL} if the results file was not created.
}
\description{
Main function implementing adaptive Monte Carlo sampling to explore parameter space.
Updates sampling distribution based on evaluated likelihoods. This is an internal
function called by \code{run_adaptive_sampling}.
}
