% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_addbmm}
\alias{torch_addbmm}
\title{Addbmm}
\arguments{
\item{batch1}{(Tensor) the first batch of matrices to be multiplied}

\item{batch2}{(Tensor) the second batch of matrices to be multiplied}

\item{beta}{(Number, optional) multiplier for \code{input} (\eqn{\beta})}

\item{input}{(Tensor) matrix to be added}

\item{alpha}{(Number, optional) multiplier for \code{batch1 @ batch2} (\eqn{\alpha})}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Addbmm
}
\section{addbmm(input, batch1, batch2, *, beta=1, alpha=1, out=None) -> Tensor }{


Performs a batch matrix-matrix product of matrices stored
in \code{batch1} and \code{batch2},
with a reduced add step (all matrix multiplications get accumulated
along the first dimension).
\code{input} is added to the final result.

\code{batch1} and \code{batch2} must be 3-D tensors each containing the
same number of matrices.

If \code{batch1} is a \eqn{(b \times n \times m)} tensor, \code{batch2} is a
\eqn{(b \times m \times p)} tensor, \code{input} must be
broadcastable  with a \eqn{(n \times p)} tensor
and \code{out} will be a \eqn{(n \times p)} tensor.

\deqn{
    out = \beta\ \mbox{input} + \alpha\ (\sum_{i=0}^{b-1} \mbox{batch1}_i \mathbin{@} \mbox{batch2}_i)
}
For inputs of type \code{FloatTensor} or \code{DoubleTensor}, arguments \code{beta} and \code{alpha}
must be real numbers, otherwise they should be integers.
}

\examples{
if (torch_is_installed()) {

M = torch_randn(c(3, 5))
batch1 = torch_randn(c(10, 3, 4))
batch2 = torch_randn(c(10, 4, 5))
torch_addbmm(M, batch1, batch2)
}
}
