% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_bmm}
\alias{torch_bmm}
\title{Bmm}
\arguments{
\item{input}{(Tensor) the first batch of matrices to be multiplied}

\item{mat2}{(Tensor) the second batch of matrices to be multiplied}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Bmm
}
\note{
This function does not broadcast .
For broadcasting matrix products, see \code{\link{torch_matmul}}.
}
\section{bmm(input, mat2, out=None) -> Tensor }{


Performs a batch matrix-matrix product of matrices stored in \code{input}
and \code{mat2}.

\code{input} and \code{mat2} must be 3-D tensors each containing
the same number of matrices.

If \code{input} is a \eqn{(b \times n \times m)} tensor, \code{mat2} is a
\eqn{(b \times m \times p)} tensor, \code{out} will be a
\eqn{(b \times n \times p)} tensor.

\deqn{
    \mbox{out}_i = \mbox{input}_i \mathbin{@} \mbox{mat2}_i
}
}

\examples{
if (torch_is_installed()) {

input = torch_randn(c(10, 3, 4))
mat2 = torch_randn(c(10, 4, 5))
res = torch_bmm(input, mat2)
res
}
}
