% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_dist}
\alias{torch_dist}
\title{Dist}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{other}{(Tensor) the Right-hand-side input tensor}

\item{p}{(float, optional) the norm to be computed}
}
\description{
Dist
}
\section{dist(input, other, p=2) -> Tensor }{


Returns the p-norm of (\code{input} - \code{other})

The shapes of \code{input} and \code{other} must be
broadcastable .
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(4))
x
y = torch_randn(c(4))
y
torch_dist(x, y, 3.5)
torch_dist(x, y, 3)
torch_dist(x, y, 0)
torch_dist(x, y, 1)
}
}
