% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_min}
\alias{torch_min}
\title{Min}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{out}{(tuple, optional) the tuple of two output tensors (min, min_indices)}

\item{other}{(Tensor) the second input tensor}
}
\description{
Min
}
\note{
When the shapes do not match, the shape of the returned output tensor
follows the broadcasting rules .
}
\section{min(input) -> Tensor }{


Returns the minimum value of all elements in the \code{input} tensor.
}

\section{min(input, dim, keepdim=False, out=None) -> (Tensor, LongTensor) }{


Returns a namedtuple \verb{(values, indices)} where \code{values} is the minimum
value of each row of the \code{input} tensor in the given dimension
\code{dim}. And \code{indices} is the index location of each minimum value found
(argmin).
}

\section{Warning}{

\code{indices} does not necessarily contain the first occurrence of each
minimal value found, unless it is unique.
The exact implementation details are device-specific.
Do not expect the same result when run on CPU and GPU in general.

If \code{keepdim} is \code{True}, the output tensors are of the same size as
\code{input} except in the dimension \code{dim} where they are of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting in
the output tensors having 1 fewer dimension than \code{input}.
}

\section{min(input, other, out=None) -> Tensor }{


Each element of the tensor \code{input} is compared with the corresponding
element of the tensor \code{other} and an element-wise minimum is taken.
The resulting tensor is returned.

The shapes of \code{input} and \code{other} don't need to match,
but they must be broadcastable .

\deqn{
    \mbox{out}_i = \min(\mbox{tensor}_i, \mbox{other}_i)
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(1, 3))
a
torch_min(a)


a = torch_randn(c(4, 4))
a
torch_min(a, dim = 1)


a = torch_randn(c(4))
a
b = torch_randn(c(4))
b
torch_min(a, other = b)
}
}
