% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_narrow}
\alias{torch_narrow}
\title{Narrow}
\arguments{
\item{input}{(Tensor) the tensor to narrow}

\item{dim}{(int) the dimension along which to narrow}

\item{start}{(int) the starting dimension}

\item{length}{(int) the distance to the ending dimension}
}
\description{
Narrow
}
\section{narrow(input, dim, start, length) -> Tensor }{


Returns a new tensor that is a narrowed version of \code{input} tensor. The
dimension \code{dim} is input from \code{start} to \code{start + length}. The
returned tensor and \code{input} tensor share the same underlying storage.
}

\examples{
if (torch_is_installed()) {

x = torch_tensor(matrix(c(1:9), ncol = 3, byrow= TRUE))
torch_narrow(x, 1, torch_tensor(0L)$sum(dim = 1), 2)
torch_narrow(x, 2, torch_tensor(1L)$sum(dim = 1), 2)
}
}
