% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_randn_like}
\alias{torch_randn_like}
\title{Randn_like}
\arguments{
\item{input}{(Tensor) the size of \code{input} will determine size of the output tensor.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned Tensor.        Default: if \code{None}, defaults to the dtype of \code{input}.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned tensor.        Default: if \code{None}, defaults to the layout of \code{input}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{None}, defaults to the device of \code{input}.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{False}.}

\item{memory_format}{(\code{torch.memory_format}, optional) the desired memory format of        returned Tensor. Default: \code{torch_preserve_format}.}
}
\description{
Randn_like
}
\section{randn_like(input, dtype=None, layout=None, device=None, requires_grad=False, memory_format=torch.preserve_format) -> Tensor }{


Returns a tensor with the same size as \code{input} that is filled with
random numbers from a normal distribution with mean 0 and variance 1.
\code{torch_randn_like(input)} is equivalent to
\code{torch_randn(input.size(), dtype=input.dtype, layout=input.layout, device=input.device)}.
}

