% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{with_enable_grad}
\alias{with_enable_grad}
\title{Enable grad}
\usage{
with_enable_grad(code)
}
\arguments{
\item{code}{code to be executed with gradient recording.}
}
\description{
Context-manager that enables gradient calculation.
Enables gradient calculation, if it has been disabled via \link{with_no_grad}.
}
\details{
This context manager is thread local; it will not affect computation in
other threads.
}
\examples{
if (torch_is_installed()) {

x <- torch_tensor(1, requires_grad=TRUE)
with_no_grad({
  with_enable_grad({
    y = x * 2
  })
})
y$backward()
x$grad

}
}
